<?php

namespace App\Http\Resources\DomicilioProduct;

use Illuminate\Http\Resources\Json\ResourceCollection;

class ReportCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->collection->map(function ($models) {
            return [
                'id' => $models->id,
                'reference' => $models->reference,
                'name' => $models->name,
                'price'  => $models->price,
                'utilities'  => $models->utilities,
                'product_id'  => $models->product_id,
                'total'  => $models->total,
                'taxt'  => $models->taxt,
                'tax_total'  => $models->tax_total,
                'old'  => true,
                'newProduct'  => 0,
                'type'  => 1,
                'storage' => $models->storage ? $models->storage : '',
                'product_variant_id' => $models->product_variant_id ? $models->product_variant_id : '',
                'quantity'  => $models->quantity,
                'selected_store' => $models->selected_store,
                'created_at' => $models->created_at->format('d-m-Y')
            ];
        });
    }
}
