<?php

namespace App\Http\Resources\Ecommerce;

use Illuminate\Http\Resources\Json\JsonResource;
use App\EconomicActivity;

class EcommerceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'nit'  => $this->nit,
            'brand_name'  => $this->brand_name,
            'phone'  => $this->phone,
            'complement_ticket' => $this->complement_ticket,
            'commercial_brand'  => $this->commercial_brand,
            'address'  => $this->address,
            'type_person' => $this->type_person,
            'typePerson' => $this->type_person == 1 ? 'Juridica' : 'Natural',
            'document_type_id' => $this->document_type_id,
            'documentType' => $this->DocumentType,
            'economic_activity_id' => $this->economic_activity_id,
            'economicActivity' => EconomicActivity::find($this->economic_activity_id),
            'great_contributor' => $this->great_contributor ? true : false,
            'self_retaining' => $this->self_retaining ? true : false,
            'type_regime' => $this->type_regime,
            'typeRegime' => $this->type_regime == 1 ? 'Responsable de IVA' : 'No Responsable de IVA',
            'city'  => $this->city,
            'user_id'  => $this->user_id,
            'rut' => $this->rut,
            'iva' => $this->iva,
            'zip_code' => $this->zip_code,
            'manager' => $this->manager,
            'manager_dni' => $this->manager_dni,
            'email_invoice'  => $this->email_invoice,
            'email_notification'  => $this->email_notification,
            'web_url'  => $this->web_url,
            'rut_path' => $this->rut_path,
            'ticket_detail' => $this->ticket_detail,
            'token_plemsi' => $this->token_plemsi,
        ];
    }
}
