<?php

namespace App\Http\Resources\External;

use Illuminate\Http\Resources\Json\JsonResource;
use App\NewType;

class DomiciliosNewResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $newType = NewType::find($this->new_type_id);
        return [
            'id' => $this->id,
            'type' => $newType ? $newType->name : 'Tipo no especificado',
            'description' => $this->description,
            'domicilio_id' => $this->domicilio_id,
            'created_at' => $this->created_at->format('Y-m-d H:i:s'), // Formateado opcional
            'updated_at' => $this->updated_at->format('Y-m-d H:i:s'),
        ];
    }
}
