<?php

namespace App\Http\Resources\PhisicalCounting;

use Illuminate\Http\Resources\Json\ResourceCollection;
use Illuminate\Support\Str;
use Illuminate\Support\Arr;

class PhisicalCountingCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->collection->map(function ($models) {
            $totalDiference = 0;
            foreach ($models->products as $prod => $product) {
                $count = $product->system_stock - $product->physical_stock;
                $totalDiference += $count;
            }
            return [
                'id' => $models->id,
                'date' => $models->created_at->format('d-m-Y'),
                'number' => $models->number,
                'products' => $models->products->count(),
                'diference' => $totalDiference
            ];
        });
    }
}
