<?php

namespace App\Http\Resources\Price;

use Illuminate\Http\Resources\Json\ResourceCollection;

class ProductPricesPosCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->collection->map(function ($models) {
            return [
                'price' => $models->price,
                'order' => $models->order
            ];
        });
    }
}
