<?php

namespace App\Http\Resources\Sender;

use Illuminate\Http\Resources\Json\JsonResource;

class SenderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $userSender = \App\User::where('log_sender_id', $this->id)->first();
        return [
            'id' => $this->id,
            'name' => $this->name,
            'dni' => $this->dni,
            'phone' => $this->phone,
            'email' => $this->email,
            'address' => $this->address,
            'company' => $this->company,
            'username' => $userSender ? $userSender->name : ''
        ];
    }
}
