<?php

namespace App\Services\DomicilioCollection;

use App\Evidence;
use App\PaymentMethod;
use App\Domicilio;
use App\DomicilioCollection;
use App\Traits\ApiResponser;
use App\Services\Domicilio\DomicilioServices;

/**
 *
 */
class DomicilioCollectionServices
{
    use ApiResponser;

    public $service;

    function __construct(DomicilioServices $domicilioServices)
    {
        $this->service = $domicilioServices;
    }

    /**
     * Create domicilio collection
     * @param array $params
     */
    public function createDomicilioCollection(array $params)
    {
        try {
            // valdiaremos las colecciones
            $domicilio = Domicilio::findOrFail($params['domicilio_id']);
            $data = [];
            if ($params['value'] > 0) {
                $totalCollection = $domicilio->Collections->sum('value');
                if ($domicilio->total > 0 and $totalCollection >= $domicilio->total) {
                    return $this->handlerException('Ya se ha recolectado todo el dinero del domicilio.');
                }
                $resto = $domicilio->total - $totalCollection;
                if (($totalCollection + $params['value']) > $domicilio->total) {
                    return $this->handlerException('Monto restante: ' . $resto);
                }
                // create collection
                $domicilioCollection = DomicilioCollection::create([
                    'value' => $params['value'],
                    'payment' => $params['payment'],
                    'domicilio_id' => $params['domicilio_id'],
                ]);

                $data['pending'] = $resto - $params['value'];
                if ($data['pending'] <= 0) {
                    $this->service->setStatuses(array($domicilio->id), 'Entregado', '');
                    //$domicilio->update(['status' => 'Entregado']);
                }
                $data['status'] = $domicilio->status;
                $data['id'] = $domicilioCollection->id;
                $data['statuses'] = $this->service->getStatusByOrderId($domicilio->id);
            } else {
                $data['status'] = $domicilio->status;
                $data['statuses'] = $this->service->getStatusByOrderId($domicilio->id);
            }
            if (isset($params['file'])) {
                $evidence = $this->service->uploadEvidence(
                    $params['file'],
                    $params['domicilio_id'],
                    'Entrega'
                );
                //$domicilioCollection->evidence = $evidence->path;
                $evidence = Evidence::where("domicilio_id", $params["domicilio_id"])
                    ->orderBy('created_at', 'desc')
                    ->first();
                $domicilioCollection->evidence = $evidence->path;
                $domicilioCollection->save();

                //SE MODIFICA EL DOMICILIO CON EL METODO DE PAGO
                $paymentMethod = PaymentMethod::where("description", "like", "%{$params['payment']}%")->first();
                $domicilio->payment_method_id = $paymentMethod->id;
                $domicilio->save();
            }
            return $data;
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }

    public function updateDomicilioCollection($domicilioCollection, $params)
    {
        if (!$domicilioCollection) {
            throw new \Exception("DomicilioCollection no encontrado");
        }

        if (isset($params['file'])) {
            if (isset($domicilioCollection->evidence)) {
                $lastEvidence = $domicilioCollection->evidence;
                Evidence::where("path", $lastEvidence)->delete();
            }

            $this->service->uploadEvidence(
                $params['file'],
                $params['domicilio_id'],
                'Entrega'
            );

            $evidence = Evidence::where("domicilio_id", $params["domicilio_id"])
                ->orderBy('created_at', 'desc')
                ->first();

            if ($evidence) {
                $domicilioCollection->evidence = $evidence->path;
            }
        }

        $domicilio = $domicilioCollection->Domicilio;

        if ($domicilio) {
            $paymentMethod = PaymentMethod::where("description", "like", "%{$params['payment']}%")->first();
            if ($paymentMethod) {
                $domicilio->payment_method_id = $paymentMethod->id;
            } else {
                throw new \Exception("Método de pago no encontrado: {$params['payment']}");
            }
            $domicilio->save();
        } else {
            throw new \Exception("Domicilio relacionado no encontrado");
        }

        if (isset($params["value"])) {
            $domicilioCollection->value = $params["value"];
        }

        if (isset($params["payment"])) {
            $domicilioCollection->payment = $params["payment"];
        }

        $domicilioCollection->save();

        return $domicilioCollection;
    }

    public function getTotalCollectionByDate()
    {
        $currentDate = date('Y-m-d');

        $totalCollectionByDate = DomicilioCollection::whereDate('created_at', '=', $currentDate)
            ->sum("value");

        return $totalCollectionByDate;
    }
}
