<?php

namespace App\Services\Onexfy\StatusHandlers;

class StatusUpdateDTO
{
    public $reference;
    public $status;
    public $note;
    public $content;

    public function __construct(
        string $reference,
        string $note,
        string $status,
        ?string $content = null
        // otros parámetros que puedan necesitarse
    ) {

        if (empty($reference)) {
            throw new \InvalidArgumentException('Reference cannot be empty');
        }

        if (empty($status)) {
            throw new \InvalidArgumentException('Reference cannot be empty');
        }

        $this->reference = $reference;
        $this->note = $note;
        $this->status = $status;
        $this->content = $content ?? null;
    }

    public function toArray(): array
    {
        return [
            'reference' => $this->reference,
            'status' => $this->status,
            'note' => $this->note,
            'content' => $this->content,
            'dropshipper_settlement' => $this->dropshipperSettlement ?? 0,
            'prov_settlement' => $this->providerSettlement ?? 0
        ];
    }
}
