<?php

namespace App\Services\Parameters;

use App\Parameter;
use App\Enums\ParameterConst;

class ParameterAccesorService
{
    public static function isActivedSettlementCollectionComission()
    {
        try {
            $parameter = Parameter::where('id', ParameterConst::IS_ACTIVED_SETTLEMENT_COLLECTION_COMISION)->first();
            return $parameter->value == 'true';
        } catch (\Exception $e) {
            throw new \Exception("No se pudo obtener el estado de recaudo en liquidación {$e->getMessage()}");
        }
    }

    public static function getSettlementCollectionComission()
    {
        try {
            $parameter = Parameter::where('id', ParameterConst::SETTLEMENT_COLLECTION_COMISION)->first();
            return $parameter->value;
        } catch (\Exception $e) {
            throw new \Exception("No se pudo obtener la comisión de recaudo en liquidación {$e->getMessage()}");
        }
    }

    public static function isActivedFullfillment()
    {
        try {
            $parameter = Parameter::where('id', ParameterConst::IS_ACTIVED_FULLFILLMENT)->first();
            return $parameter->value == 'true';
        } catch (\Exception $e) {
            throw new \Exception("No se pudo obtener el estado de fullfillment {$e->getMessage()}");
        }
    }

    public static function getFullfillmentComission()
    {
        try {
            $parameter = Parameter::where('id', ParameterConst::FULLFILLMENT_COMISION)->first();
            return $parameter->value;
        } catch (\Exception $e) {
            throw new \Exception("No se pudo obtener la comisión de fullfillment {$e->getMessage()}");
        }
    }

    public static function isActivedProductsTable()
    {
        try {
            $parameter = Parameter::where('id', ParameterConst::IS_ACTIVED_PRODUCTS_TABLE)->first();
            return $parameter->value == 'true';
        } catch (\Exception $e) {
            throw new \Exception("No se pudo obtener el estado de la tabla de productos {$e->getMessage()}");
        }
    }

    public static function getWhatsappMessageOrder()
    {
        try {
            $parameter = Parameter::where('id', ParameterConst::WHATSAPP_MESSAGE_ORDER)->first();
            return $parameter->value;
        } catch (\Exception $e) {
            throw new \Exception("No se pudo obtener el mensaje de whatsapp {$e->getMessage()}");
        }
    }

    public static function domiciliariesCanGetOrdersWithoutAssignation()
    {
        try {
            $parameter = Parameter::where('id', ParameterConst::DOMICILIARIES_CAN_GET_ORDERS_WITHOUT_ASSIGNATION)->first();
            return $parameter->value == 'true';
        } catch (\Exception $e) {
            throw new \Exception("No se pudo obtener el estado de domiciliarios que pueden obtener pedidos sin asignación {$e->getMessage()}");
        }
    }
}
