<?php

namespace App\Services\Parameters;

use App\Parameter;
use App\Http\Resources\Parameters\ParameterResource;
use App\Enums\ParameterConst;

class ParameterService
{
    public function getAllParameters()
    {
        return ParameterResource::collection(Parameter::all());
    }

    public function getAllParametersPaginated(int $perPage, string $search)
    {
        $query = Parameter::query()
            ->when($search, function ($query) use ($search) {
                $query->where(function ($q) use ($search) {
                    $q->where("id", "like", "%{$search}%")
                        ->orWhere("name", "like", "%{$search}%")
                        ->orWhere("type", "like", "%{$search}%")
                        ->orWhere("value", "like", "%{$search}%");
                });
            });

        // Filtrar parámetros según la activación
        $query->where(function ($query) {
            // Mostrar todos los parámetros excepto los que dependen de una condición de activación
            $query->whereNotIn('id', [
                ParameterConst::SETTLEMENT_COLLECTION_COMISION,
                ParameterConst::FULLFILLMENT_COMISION
            ]);

            // Mostrar el parámetro 2 (SETTLEMENT_COLLECTION_COMISION) solo si el parámetro 1 está activado
            if (ParameterAccesorService::isActivedSettlementCollectionComission()) {
                $query->orWhere('id', ParameterConst::SETTLEMENT_COLLECTION_COMISION);
            }

            // Mostrar el parámetro 4 (FULLFILLMENT_COMISION) solo si el parámetro 3 está activado
            if (ParameterAccesorService::isActivedFullfillment()) {
                $query->orWhere('id', ParameterConst::FULLFILLMENT_COMISION);
            }
        });

        $results = $query->orderBy('created_at', 'ASC')
            ->paginate($perPage);

        return ParameterResource::collection($results)->response()->getData(true);
    }

    public function create($data)
    {
        return Parameter::create($data);
    }

    public function update($parameter, $data)
    {
        $parameter->update($data);
        return $parameter;
    }

    public function deleteParameter(Parameter $parameter)
    {
        $parameter->delete();
        return $parameter;
    }
}
