<?php
namespace App\Services\Roles;

use DB;
use App\Traits\ApiResponser;
use Illuminate\Support\Facades\Cache;

final class RoleServices
{
    /**
     * List departaments
     */
    public function listRoles() {
        try {
            if (Cache::get('roles')) {
                return Cache::get('roles');
            }
            $roles = DB::table('roles')
            ->select(
                'id as value',
                'name as label'
            )
            ->whereNotIn('name', ['Domiciliario', 'Remitente'])
            ->get();
            Cache::put('roles', $roles, 6000000);
            return $roles;
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage(), 400);
        }
    }
}
