<?php

namespace App\Services\Settlement;

use App\Enums\DomicilioStatusConst;
use App\Domicilio;
use App\Status;
use App\Services\Parameters\ParameterAccesorService;
//use Illuminate\Support\Facades\Log;

class SettlementCalculationService
{
    public function calculateLastMile($finalPrice, $discount)
    {
        $discount = $discount / 100;
        return $finalPrice - ($finalPrice * $discount);
    }

    public function getComission($sender)
    {
        $comission = 0;

        $isActivedSettlementCollectionComission = ParameterAccesorService::isActivedSettlementCollectionComission();

        if ($isActivedSettlementCollectionComission) {
            $value = ParameterAccesorService::getSettlementCollectionComission();
            $comission = intval($value) ?? 0;
            $comission = $comission / 100;
        } else {
            $comission = $sender->tax_collection ?? 0;
        }

        return $comission;
    }

    public function generateDomicilioData(Domicilio $domicilio)
    {
        $comission = $this->getComission($domicilio->logSender);
        //Log::info("PROBANDO COMISION " . $comission);

        $obj = new \stdClass();
        $obj->reference = $domicilio->reference;
        $obj->status = $domicilio->status;
        $obj->date = $domicilio->created_at->format('Y/m/d');
        $obj->delivery_date = $this->getDeliveredDate($domicilio);
        $obj->city = $domicilio->zone->city->name;
        $obj->sender = $domicilio->logSender->name;
        $obj->collection_value = $domicilio->status === DomicilioStatusConst::FAILED ? 0 : $domicilio->total;
        $obj->collection_comission = $domicilio->total * $comission;

        if (ParameterAccesorService::isActivedFullfillment()) {
            $obj->fullfilment = $domicilio->logSender->fullfilment ?? ParameterAccesorService::getFullfillmentComission();
        } else {
            $obj->fullfilment = 0;
        }

        $obj->payment_method = $domicilio->Collections->count() > 0 ? $domicilio->Collections->first()->payment : null;

        $obj->last_mille = $this->calculateLastMile(
            $domicilio->delivery,
            $domicilio->logSender->discount
        );

        $obj->total = ($obj->collection_value - $obj->collection_comission) - $obj->fullfilment - $obj->last_mille;

        if ($domicilio->dropshipper->count() > 0) {
            $dropshipperSettlement = $domicilio->dropshipper->first();
            $obj = $this->generateDataDropshipper($obj, $dropshipperSettlement, $domicilio->delivery, $comission);
        }

        return $obj;
    }

    public function getDeliveredDate($domicilioId)
    {
        $status = Status::where("domicilio_id", $domicilioId->id)
            ->where("status", DomicilioStatusConst::DELIVERED)
            ->get()
            ->last();
        if ($status) {
            return $status->created_at->format('Y/m/d');
        }

        return null;
    }

    private function generateDataDropshipper($data, $dropshipperSettlement, $finallyPrice, $comission)
    {
        $data->provider_cost = $dropshipperSettlement->provider_cost;

        $data->name_dropshipper = $dropshipperSettlement->name_dropshipper;

        $data->total_dropshipper = $data->collection_value > 0
            ? $data->collection_value - $data->provider_cost : 0;

        $data->com_collection_provider = $data->provider_cost * $comission;

        $data->com_collection_dropshipper = $data->collection_value > 0
            ? $data->total_dropshipper * $comission : 0;

        $data->dropshipper_settlement = $data->collection_value > 0
            ? $data->total_dropshipper - $data->com_collection_dropshipper - $finallyPrice : 0;

        $data->provider_settlement = $data->collection_value > 0
            ? $data->provider_cost - $data->com_collection_provider - $data->fullfilment : $data->com_collection_provider + $data->fullfilment;

        $data->logistic_cost = $data->fullfilment + $data->com_collection_dropshipper + $data->com_collection_provider + $finallyPrice;

        //Log::info("PROBANDO COMISION DROPSHIPPER " . $comission);
        //Log::info("PROBANDO DATA DROPSHIPPER " . json_encode($data));
        return $data;
    }

    public function sumOperationCost($pdfData)
    {
        $total = 0;

        foreach ($pdfData->domicilios as $domicilio) {
            $total += $domicilio->logistic_cost;
        }

        return $total;
    }
}
