<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class TypePayment extends Model
{

    public function Domicilios()
    {
        return $this->hasMany('App\Domicilio');
    }

    public function Users() {
        return $this->belongsToMany('App\User', 'payment_user');
    }
    
    public function DomiciliosTypePayments() {
        return $this->belongsToMany('App\User', 'domicilio_type_payment');
    }

    //fillable
    protected $fillable = ['name', 'user_id', 'photo', 'black_path'];

    //scopes local
    public function scopeAsc($query)
    {
        return $query->orderBy('id', 'ASC');
    }

    public function scopeDesc($query)
    {
        return $query->orderBy('id', 'DESC');
    }

    public function scopeUserId($query, $id)
    {
        return $query->where('user_id', $id);
    }
    public function getNameAttribute($value)
    {
        return ucfirst($value);
    }
}
