<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLogChangeControlTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('log_change_control', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('table', 60);
            $table->integer('record_id');
            $table->string('field', 60);
            $table->string('old_value');
            $table->string('new_value');
            $table->string('operation', 12);
            $table->integer('user_id');
            $table->string('created_at');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('log_change_control');
    }
}
