<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateConfigurationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('configurations', function (Blueprint $table) {
            $table->id();
            $table->timestamps();
            $table->string('brand_img', 255)->nullable();
            $table->string('brand_name', 90)->nullable();
            $table->string('brand_logo', 255)->nullable();
            $table->string('brand_mini_logo', 255)->nullable();
            $table->string('brand_color', 10)->nullable();
            $table->longText('guide_footer')->nullable();
            $table->unsignedBigInteger('user_id')->unsigned()->nullable();
            $table->foreign(['user_id'])->references(['id'])->on('users')->onUpdate('CASCADE')->onDelete('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('configurations');
    }
}
