<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSettlementsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('settlements', function (Blueprint $table) {
            $table->id();
            $table->string("pdf_url")->nullable();
            $table->foreignId("created_by")
                ->nullable()
                ->references("id")
                ->on("users")
                ->onUpdate("cascade")
                ->nullOnDelete();
            $table->foreignId("modified_by")
                ->nullable()
                ->references("id")
                ->on("users")
                ->onUpdate("cascade")
                ->nullOnDelete();
            $table->boolean("is_open")->default(true);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('settlements');
    }
}
