<?php

namespace Tests\Feature;

use App\CostCenter;
use App\User;
use Tests\TestCase;
use Illuminate\Support\Facades\Hash;

class CostCenterTest extends TestCase
{
    public function setUp(): void
    {
        parent::setUp();

        $user = User::where('email', 'costCenterTest@test.com')->first();

        if($user){
            $user->delete();
        }

        $user = new User;

        $data = array(
            'name' => 'costCenterTest',
            'email' => 'costCenterTest@test.com',
            'password' => Hash::make('test'),
            'type' => 1,
        );

        $user = $user::create($data);

        $this->actingAs($user, 'api');
    }

    public function test_can_list()
    {
        $this->json('GET', route('costCenters.index', ['search' => 'test']))
        ->assertStatus(200);
    }

    public function test_can_store()
    {
        $data = array(
            'name' => 'Test' . rand(0, 50000)
        );

        $costCenter = $this->json('POST', route('costCenters.store'), $data)
            ->assertStatus(201);

        $costCenter = json_decode($costCenter->content());

        CostCenter::find($costCenter->id)->delete();
    }

    public function test_cannot_store()
    {
        $data = array(
            'name' => ''
        );

        $this->json('POST', route('costCenters.store'), $data)
            ->assertStatus(422);
    }

    public function test_can_update()
    {
        $costCenter = new CostCenter;

        $data = array(
            'name' => 'Test' . rand(0, 50000)
        );

        $costCenter = $this->json('POST', route('costCenters.store'), $data);
        $costCenter = json_decode($costCenter->content());

        $data = array(
            'name' => 'Test-edit' . rand(0, 50000)
        );

        $this->json('PUT', route('costCenters.update', $costCenter->id), $data)
            ->assertStatus(200);

        CostCenter::find($costCenter->id)->delete();
    }

    public function test_cannot_update()
    {
        $costCenter = new CostCenter;

        $dataOld = array(
            'name' => 'Test' . rand(0, 50000)
        );

        $costCenter = $this->json('POST', route('costCenters.store'), $dataOld);
        $costCenter = json_decode($costCenter->content());

        $data = array(
            'name' => ''
        );

        $this->json('PUT', route('costCenters.update', $costCenter->id), $data)
            ->assertStatus(422);

        CostCenter::find($costCenter->id)->delete();
    }

    public function test_can_show()
    {
        $costCenter = new CostCenter;

        $data = array(
            'name' => 'Test' . rand(0, 50000)
        );

        $costCenter = $this->json('POST', route('costCenters.store'), $data);
        $costCenter = json_decode($costCenter->content());

        $this->json('GET', route('costCenters.show', $costCenter->id))
        ->assertStatus(200);
    }

    public function test_can_delete()
    {
        $costCenter = new CostCenter;

        $data = array(
            'name' => 'Test' . rand(0, 50000)
        );

        $costCenter = $this->json('POST', route('costCenters.store'), $data);
        $costCenter = json_decode($costCenter->content());

        $this->json('DELETE', route('costCenters.destroy', $costCenter->id))
        ->assertStatus(200);
    }

    public function test_cannot_delete()
    {
        $this->json('DELETE', route('costCenters.destroy', 0))
        ->assertStatus(404);
    }
}
